<?php
// add_license.php - simple admin UI to manage licenses (password protected)
require __DIR__ . '/config.php';
session_start();

// simple password protection
if (isset($_POST['password'])) {
    if ($_POST['password'] === CSA_ADMIN_PASSWORD) {
        $_SESSION['csa_admin'] = true;
    } else {
        $err = 'Invalid password';
    }
}

if (!isset($_SESSION['csa_admin']) || $_SESSION['csa_admin'] !== true) {
    ?>
    <!doctype html><html><head><meta charset="utf-8"><title>CSA License Admin</title></head><body>
    <h2>CSA License Admin</h2>
    <?php if (!empty($err)) echo '<p style="color:red;">'.htmlspecialchars($err).'</p>'; ?>
    <form method="post"><label>Admin password: <input type="password" name="password"></label> <button type="submit">Login</button></form>
    <p>Change the admin password in <code>config.php</code> after install.</p>
    </body></html>
    <?php
    exit;
}

// handle actions: create, revoke
$mysqli = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($mysqli->connect_errno) die('DB connect error');

$action = isset($_POST['action']) ? $_POST['action'] : '';
if ($action === 'create') {
    $license = !empty($_POST['license']) ? trim($_POST['license']) : strtoupper(substr(bin2hex(random_bytes(8)),0,16));
    $expires = !empty($_POST['expires']) ? trim($_POST['expires']) : null;
    $created = date('Y-m-d H:i:s');
    $stmt = $mysqli->prepare('INSERT INTO csa_licenses (license_key, bound_domain, active, created, expires) VALUES (?, NULL, 1, ?, ?)');
    $stmt->bind_param('sss', $license, $created, $expires);
    if ($stmt->execute()) {
        $msg = 'License created: ' . $license;
    } else {
        $err = 'Insert failed: ' . $mysqli->error;
    }
}

if ($action === 'revoke' && !empty($_POST['id'])) {
    $id = intval($_POST['id']);
    $stmt = $mysqli->prepare('UPDATE csa_licenses SET active = 0 WHERE id = ?');
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $msg = 'License revoked';
}

// fetch licenses
$res = $mysqli->query('SELECT * FROM csa_licenses ORDER BY id DESC LIMIT 200');
$licenses = $res->fetch_all(MYSQLI_ASSOC);
?>
<!doctype html><html><head><meta charset="utf-8"><title>CSA License Admin</title>
<style>table{border-collapse:collapse}td,th{border:1px solid #ddd;padding:6px}</style>
</head><body>
<h2>CSA License Admin</h2>
<p><a href="add_license.php?logout=1">Logout</a> | Edit <code>config.php</code> to change DB/admin password.</p>
<?php if(!empty($msg)) echo '<p style="color:green;">'.htmlspecialchars($msg).'</p>'; ?>
<?php if(!empty($err)) echo '<p style="color:red;">'.htmlspecialchars($err).'</p>'; ?>

<h3>Create license</h3>
<form method="post">
<input type="hidden" name="action" value="create">
<p>License (optional, leave blank to auto-generate): <input name="license"></p>
<p>Expires (YYYY-MM-DD HH:MM:SS) or blank: <input name="expires" placeholder="2026-12-31 23:59:59"></p>
<p><button>Create</button></p>
</form>

<h3>Existing licenses</h3>
<table><thead><tr><th>ID</th><th>License</th><th>Bound Domain</th><th>Active</th><th>Created</th><th>Expires</th><th>Action</th></tr></thead><tbody>
<?php foreach($licenses as $row): ?>
<tr>
<td><?php echo htmlspecialchars($row['id']); ?></td>
<td><code><?php echo htmlspecialchars($row['license_key']); ?></code></td>
<td><?php echo htmlspecialchars($row['bound_domain']); ?></td>
<td><?php echo $row['active'] ? 'Yes' : 'No'; ?></td>
<td><?php echo htmlspecialchars($row['created']); ?></td>
<td><?php echo htmlspecialchars($row['expires']); ?></td>
<td>
<?php if($row['active']): ?>
<form method="post" style="display:inline">
<input type="hidden" name="action" value="revoke">
<input type="hidden" name="id" value="<?php echo htmlspecialchars($row['id']); ?>">
<button>Revoke</button>
</form>
<?php endif; ?>
</td>
</tr>
<?php endforeach; ?>
</tbody></table>
</body></html>
<?php
// logout handler
if (isset($_GET['logout'])) { session_destroy(); header('Location: add_license.php'); exit; }
?>